# 画面設計書 91-Google Cloud設定

## 概要

本ドキュメントは、GitLabにおけるGoogle Cloud連携設定画面の設計仕様を記述したものです。

### 本画面の処理概要

この画面では、GitLabプロジェクトとGoogle Cloud Platform (GCP) の連携設定を管理します。サービスアカウントの管理、GCPリージョンの設定、デプロイメントやデータベース連携の設定画面へのナビゲーションを提供します。

**業務上の目的・背景**：
クラウドネイティブな開発環境において、GitLabのCI/CDパイプラインからGoogle Cloudリソースへのアクセスが必要となるケースが増加しています。本画面は、Google CloudとGitLabプロジェクトを安全に連携させるための設定インターフェースを提供し、DevOpsワークフローを効率化します。これにより、開発者はGCPのサービスアカウントを管理し、デプロイメント先のリージョンを設定し、Cloud SQLなどのデータベースサービスとの連携を構成できます。

**画面へのアクセス方法**：
1. プロジェクト画面から左側ナビゲーションの「インフラストラクチャ」セクションを展開
2. 「Google Cloud」をクリック
3. 自動的に「Configuration」（設定）サブページにリダイレクト

**主要な操作・処理内容**：
1. Google Cloud サービスアカウントの一覧表示と新規作成
2. GCPリージョンの設定（CI変数として保存）
3. デプロイメント設定画面への遷移
4. データベース連携設定画面への遷移
5. Google OAuth認証の取り消し（認証済みの場合）

**画面遷移**：
- 遷移元：プロジェクトダッシュボード、インフラストラクチャメニュー
- 遷移先：サービスアカウント作成画面、GCPリージョン設定画面、デプロイメント設定画面、データベース設定画面

**権限による表示制御**：
- `admin_project_google_cloud` 権限が必要
- Google OAuth2がGitLabインスタンスで有効化されている必要がある
- OAuth認証が有効な場合のみ「認証の取り消し」オプションが表示される

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 60 | Kubernetesクラスター連携 | 主機能 | Google Cloud連携の設定 |
| 50 | CI変数管理 | 補助機能 | GCPリージョン設定のCI変数への保存 |
| 88 | OAuth2プロバイダ | 補助機能 | Google OAuth2認証の処理 |

## 画面種別

設定画面（ダッシュボード形式）

## URL/ルーティング

- URL: `/:namespace_id/:project_id/-/google_cloud/configuration`
- ルート定義: `config/routes/project.rb`
- コントローラー: `Projects::GoogleCloud::ConfigurationController#index`

## 入出力項目

### 入力項目

本画面は主に表示・ナビゲーション用途であり、直接の入力項目は存在しません。設定変更は各サブ画面で行います。

### 出力項目（表示データ）

| 項目名 | データ型 | 説明 |
|--------|---------|------|
| サービスアカウント一覧 | Array | プロジェクトに関連付けられたGCPサービスアカウント |
| GCPリージョン一覧 | Array | 設定されたGCPリージョン（環境スコープ付き） |
| 認証取り消しURL | String/null | Google OAuth認証が有効な場合のみ値を持つ |

## 表示項目

| 項目名 | 表示形式 | 説明 |
|--------|---------|------|
| Configuration URL | リンク | 現在の設定画面へのパス |
| Deployments URL | リンク | デプロイメント設定画面へのパス |
| Databases URL | リンク | データベース設定画面へのパス |
| Service Accounts | リスト | 登録済みサービスアカウント一覧 |
| GCP Regions | リスト | 設定済みリージョン（環境スコープ別） |
| Create Service Account URL | リンク | サービスアカウント作成画面へのパス |
| Configure GCP Regions URL | リンク | リージョン設定画面へのパス |
| Revoke OAuth URL | リンク/非表示 | OAuth認証取り消し（認証時のみ） |

## イベント仕様

### 1-サービスアカウント作成ボタン押下

**処理フロー**：
1. 「サービスアカウント作成」ボタンをクリック
2. `/projects/:id/google_cloud/service_accounts` へ遷移
3. サービスアカウント作成フォームを表示

### 2-GCPリージョン設定ボタン押下

**処理フロー**：
1. 「GCPリージョン設定」ボタンをクリック
2. `/projects/:id/google_cloud/gcp_regions` へ遷移
3. リージョン設定フォームを表示

### 3-OAuth認証取り消しボタン押下

**処理フロー**：
1. 「認証を取り消す」ボタンをクリック
2. `/projects/:id/google_cloud/revoke_oauth` へPOSTリクエスト
3. セッションからGoogle OAuthトークンを削除
4. 設定画面にリダイレクト

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | ci_variables | SELECT | GCPリージョン設定の取得 |
| 画面表示 | service_accounts | SELECT | サービスアカウント一覧の取得 |

### テーブル別更新項目詳細

#### ci_variables（参照のみ）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | key | GCP_REGION_CI_VAR_KEY に一致 | GCPリージョン設定 |
| SELECT | value | リージョン値 | - |
| SELECT | environment_scope | 環境スコープ | - |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|------------|------|--------------|---------|
| MSG-001 | エラー | This GitLab instance not configured for Google Oauth2. | Google OAuth2が未設定 |
| MSG-002 | エラー | Access Denied | admin_project_google_cloud 権限なし |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| Google OAuth2未設定 | 403エラー画面を表示、エラーメッセージを表示 |
| 権限不足 | 403 Access Denied画面を表示 |
| プロジェクト未存在 | 404エラー画面を表示 |

## 備考

- 本画面はVue.jsコンポーネント（`#js-google-cloud-configuration`）で実装されている
- 画面データは`@js_data`としてJSON形式でフロントエンドに渡される
- CloudSeed機能の一部として実装されている
- Google OAuth2認証はGitLabインスタンス全体の設定が必要

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、フロントエンドに渡されるJSONデータ構造を理解することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | configuration_controller.rb | `app/controllers/projects/google_cloud/configuration_controller.rb` | js_dataハッシュの構造を確認 |

**読解のコツ**: Rubyのハッシュ構造が最終的にJSON形式でフロントエンドに渡されます。キー名がそのままJavaScriptのプロパティ名になります。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラーを特定します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | configuration_controller.rb | `app/controllers/projects/google_cloud/configuration_controller.rb` | indexアクションの処理フロー |

**主要処理フロー**:
1. **7-19行**: `index`メソッドでjs_dataハッシュを構築
2. **11行**: `ServiceAccountsService`を呼び出しサービスアカウント一覧を取得
3. **16行**: `gcp_regions`プライベートメソッドでCI変数からリージョン情報を取得
4. **17行**: `revoke_oauth_url`でOAuth認証状態を確認

#### Step 3: 基底コントローラーを理解する

認証・認可のロジックを理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | base_controller.rb | `app/controllers/projects/google_cloud/base_controller.rb` | before_actionフィルタの処理 |

**主要処理フロー**:
- **7行**: `admin_project_google_cloud!` - 権限チェック
- **8行**: `google_oauth2_enabled!` - OAuth2設定確認
- **27-38行**: `validate_gcp_token!` - GCPトークン検証

#### Step 4: サービス層を理解する

サービスアカウント取得のロジックを理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | service_accounts_service.rb | `app/services/cloud_seed/google_cloud/service_accounts_service.rb` | find_for_projectメソッドの実装 |

### プログラム呼び出し階層図

```
Projects::GoogleCloud::ConfigurationController#index
    │
    ├─ before_action: admin_project_google_cloud! (BaseController)
    │      └─ can?(current_user, :admin_project_google_cloud, project)
    │
    ├─ before_action: google_oauth2_enabled! (BaseController)
    │      └─ Gitlab::Auth::OAuth::Provider.config_for('google_oauth2')
    │
    ├─ CloudSeed::GoogleCloud::ServiceAccountsService#find_for_project
    │      └─ プロジェクトに関連するサービスアカウントを取得
    │
    ├─ gcp_regions (private method)
    │      └─ Ci::VariablesFinder#execute
    │             └─ CI変数からGCPリージョン設定を取得
    │
    └─ revoke_oauth_url (private method)
           └─ GoogleApi::CloudPlatform::Client#validate_token
                  └─ OAuth認証トークンの有効性を確認
```

### データフロー図

```
[入力]               [処理]                    [出力]

リクエスト ───▶ ConfigurationController#index ───▶ @js_data (JSON)
                       │                              │
                       ├─ ServiceAccountsService      ├─ serviceAccounts
                       │      └─ DB検索               │
                       │                              │
                       ├─ Ci::VariablesFinder         ├─ gcpRegions
                       │      └─ CI変数検索           │
                       │                              │
                       └─ GoogleApi::Client           └─ revokeOauthUrl
                              └─ トークン検証
                                                      │
                                                      ▼
                                                Vue.js Component
                                                (#js-google-cloud-configuration)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| index.html.haml | `app/views/projects/google_cloud/configuration/index.html.haml` | テンプレート | 画面のHTMLテンプレート |
| configuration_controller.rb | `app/controllers/projects/google_cloud/configuration_controller.rb` | コントローラー | 画面のメインコントローラー |
| base_controller.rb | `app/controllers/projects/google_cloud/base_controller.rb` | コントローラー | 共通認証・認可ロジック |
| service_accounts_service.rb | `app/services/cloud_seed/google_cloud/service_accounts_service.rb` | サービス | サービスアカウント管理 |
| variables_finder.rb | `app/finders/ci/variables_finder.rb` | ファインダー | CI変数検索 |
| client.rb | `lib/google_api/cloud_platform/client.rb` | クライアント | Google Cloud API連携 |
| project.rb | `config/routes/project.rb` | ルーティング | URLルーティング定義（310-324行） |
